DROP TABLE IF EXISTS `%table_prefix%users`;
CREATE TABLE `%table_prefix%users` (
  `user_id` bigint(32) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) DEFAULT NULL,
  `user_username` varchar(255) NOT NULL,
  `user_date` datetime NOT NULL,
  `user_date_gmt` datetime NOT NULL,
  `user_email` varchar(255) DEFAULT NULL,
  `user_avatar_filename` varchar(255) DEFAULT NULL,
  `user_facebook_username` varchar(255) DEFAULT NULL,
  `user_twitter_username` varchar(255) DEFAULT NULL,
  `user_website` varchar(255) DEFAULT NULL,
  `user_background_filename` varchar(255) DEFAULT NULL,
  `user_bio` varchar(255) DEFAULT NULL,
  `user_timezone` varchar(255) NOT NULL,
  `user_language` varchar(255) DEFAULT NULL,
  `user_status` enum('valid','awaiting-confirmation','awaiting-email','banned') NOT NULL,
  `user_is_admin` tinyint(1) NOT NULL DEFAULT '0',
  `user_is_manager` tinyint(1) NOT NULL DEFAULT '0',
  `user_is_private` tinyint(1) NOT NULL DEFAULT '0',
  `user_palette_id` int(11) NOT NULL DEFAULT '0',
  `user_newsletter_subscribe` tinyint(1) NOT NULL DEFAULT '1',
  `user_show_nsfw_listings` tinyint(1) NOT NULL DEFAULT '0',
  `user_image_count` bigint(32) NOT NULL DEFAULT '0',
  `user_album_count` bigint(32) NOT NULL DEFAULT '0',
  `user_image_keep_exif` tinyint(1) NOT NULL DEFAULT '1',
  `user_image_expiration` varchar(255) DEFAULT NULL,
  `user_registration_ip` varchar(255) NOT NULL,
  `user_likes` bigint(32) NOT NULL DEFAULT '0' COMMENT 'Likes made to content owned by this user',
  `user_liked` bigint(32) NOT NULL DEFAULT '0' COMMENT 'Likes made by this user',
  `user_following` bigint(32) NOT NULL DEFAULT '0',
  `user_followers` bigint(32) NOT NULL DEFAULT '0',
  `user_content_views` bigint(32) NOT NULL DEFAULT '0',
  `user_notifications_unread` bigint(32) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`user_username`(191)) USING BTREE,
  UNIQUE KEY `email` (`user_email`(191)) USING BTREE,
  KEY `user_date_gmt` (`user_date_gmt`),
  KEY `user_status` (`user_status`),
  KEY `user_is_admin` (`user_is_admin`),
  KEY `user_is_manager` (`user_is_manager`),
  KEY `user_is_private` (`user_is_private`),
  KEY `user_palette_id` (`user_palette_id`),
  KEY `user_newsletter_subscribe` (`user_newsletter_subscribe`),
  KEY `user_show_nsfw_listings` (`user_show_nsfw_listings`),
  KEY `user_image_count` (`user_image_count`),
  KEY `user_album_count` (`user_album_count`),
  KEY `user_image_keep_exif` (`user_image_keep_exif`),
  KEY `user_image_expiration` (`user_image_expiration`),
  KEY `user_registration_ip` (`user_registration_ip`),
  KEY `user_likes` (`user_likes`),
  KEY `user_following` (`user_following`),
  KEY `user_followers` (`user_followers`),
  KEY `user_liked` (`user_liked`),
  KEY `user_content_views` (`user_content_views`),
  FULLTEXT KEY `searchindex` (`user_name`,`user_username`)
) ENGINE=%table_engine% DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
