<?php

/*
 * This file is part of Chevere.
 *
 * (c) Rodolfo Berrios <rodolfo@chevere.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Chevere\Parameter\Interfaces;

use Chevere\Throwable\Exceptions\InvalidArgumentException;

/**
 * Describes the component in charge of defining a parameter of type array.
 */
interface ArrayParameterInterface extends ParameterInterface
{
    /**
     * Return an instance with the specified default value.
     *
     * This method MUST retain the state of the current instance, and return
     * an instance that contains the specified default value.
     *
     * @param array<mixed, mixed> $value
     * @throws InvalidArgumentException
     */
    public function withDefault(array $value): self;

    /**
     * Return an instance with the specified property.
     *
     * This method MUST retain the state of the current instance, and return
     * an instance that contains the specified property.
     *
     * @throws InvalidArgumentException
     */
    public function withParameter(ParameterInterface ...$parameter): self;

    /**
     * Provides access to the default value.
     *
     * @return array<mixed, mixed>
     */
    public function default(): array;

    /**
     * Provides access to the parameters.
     */
    public function parameters(): ParametersInterface;
}
